#include <iostream>
#include <cmath>
#include <complex>
#include <stdexcept>

using namespace std;

complex<double> impedanceC(double c, double f) {
	if (c==0.0)
		throw domain_error("Capaciteit == 0");
	if (f==0.0)
		throw domain_error("Frequentie == 0");
	return complex<double>(0, -1/(2*M_PI*f*c));
}

int main() {
	try {
		cout<<impedanceC(1e-6, 1e3)<<endl;
		cin.get();
		cout<<impedanceC(1e-6, 0)<<endl;
		cout<<"Dit was het!"<<endl;
	} catch (domain_error& e) {
		cout<<e.what()<<endl;
	}
	cin.get();
	cout<<"The END."<<endl;
	cin.get();
	return 0;
}

/*
C:\SOP2>impC.exe
(0,-159.155)

Frequentie == 0

The END.


C:\SOP2>
*/
