#include <iostream>
#include <cmath>
#include <complex>

using namespace std;

class ImpedanceError {
public:
	virtual ~ImpedanceError();
	virtual string getErrorMessage() const =0;
};

ImpedanceError::~ImpedanceError() {
}

class FrequencyError: public ImpedanceError {
public:
	virtual string getErrorMessage() const;
};

string FrequencyError::getErrorMessage() const {
	return "Frequentie == 0";
}

class CapacityError: public ImpedanceError {
public:
	virtual string CapacityError::getErrorMessage() const;
};

string CapacityError::getErrorMessage() const {
	return "Capaciteit == 0";
}

complex<double> impedanceC(double c, double f) {
	if (c==0.0)
		throw CapacityError();
	if (f==0.0)
		throw FrequencyError();
	return complex<double>(0, -1/(2*M_PI*f*c));
}

int main() {
	try {
		cout<<impedanceC(1e-6, 1e3)<<endl;
		cin.get();
		cout<<impedanceC(1e-6, 0)<<endl;
		cout<<"Dit was het!"<<endl;
	} catch (ImpedanceError& e) {
		cout<<e.getErrorMessage()<<endl;
	}
	cin.get();
	cout<<"The END."<<endl;
	cin.get();
	return 0;
}

/*
C:\SOP3>impC.exe
(0,-159.155)

Frequentie == 0

The END.


C:\SOP3>
*/
