#ifndef _THR_Bd_StackWithArray_
#define _THR_Bd_StackWithArray_

#include "stack.h"

template <typename T> class StackWithArray: public Stack<T> {
public:
	explicit StackWithArray(int size);
	~StackWithArray();
	virtual void push(const T& t);
	virtual void pop();
	virtual const T& top() const;
	virtual bool empty() const;
	virtual bool full() const;
private:
	T* a;  // pointer naar de array
	int s; // size van a (max aantal elementen op de stack)
	int i; // index in a van de top van de stack
};

template <typename T> StackWithArray<T>::StackWithArray(int size):
		a(0), s(size), i(-1) {
	if (s<=0) {
		cerr<<"Stack size should be >0"<<endl;
		s=0;
	}
	else
		a=new T[s];
}
template <typename T> StackWithArray<T>::~StackWithArray() {
	delete[] a;
}
template <typename T> void StackWithArray<T>::push(const T& t) {
	if (full())
		cerr<<"Can't push on an full stack"<<endl;
	else
		a[++i]=t;
}
template <typename T> void StackWithArray<T>::pop() {
	if (empty())
		cerr<<"Can't pop from an empty stack"<<endl;
	else
		--i;
}
template <typename T> const T& StackWithArray<T>::top() const {
	if (empty()) {
		cerr<<"Can't top from an empty stack"<<endl;
		exit(-1);
		// no valid return possible
	}
	return a[i];
}
template <typename T> bool StackWithArray<T>::empty() const {
	return i==-1;
}
template <typename T> bool StackWithArray<T>::full() const {
	return i==s-1;
}

#endif
