#ifndef _THR_Bd_StackWithList_
#define _THR_Bd_StackWithList_

#include "stack.h"

template <typename T> class StackWithList: public Stack<T> {
public:
	StackWithList();
	virtual ~StackWithList();
	virtual void push(const T& t);
	virtual void pop();
	virtual const T& top() const;
	virtual bool empty() const;
	virtual bool full() const;
private:
	class Node {
	public:
		Node(const T& t, Node* n);
		T data;
		Node* next;
	};
	Node* p; // pointer naar de Node aan de top van de stack
};

template <typename T> StackWithList<T>::StackWithList(): p(0) {
}

template <typename T> StackWithList<T>::~StackWithList() {
	while (!empty())
		pop();
}

template <typename T> void StackWithList<T>::push(const T& t) {
	p=new Node(t, p);
}

template <typename T> void StackWithList<T>::pop() {
	if (empty())
		cerr<<"Can't pop from an empty stack"<<endl;
	else {
		Node* old(p);
		p=p->next;
		delete old;
	}
}

template <typename T> const T& StackWithList<T>::top() const {
	if (empty()) {
		cerr<<"Can't top from an empty stack"<<endl;
		exit(-1);
		// no valid return possible
	}
	return p->data;
}

template <typename T> bool StackWithList<T>::empty() const {
	return p==0;
}

template <typename T> bool StackWithList<T>::full() const {
	return false;
}

template <typename T> StackWithList<T>::Node::Node(const T& t, Node* n):
		 data(t), next(n) {
}

#endif
