// Een zelfgemaakt alternatief voor int[]

#include <iostream>
#include <cassert>
using namespace std;

class Vector {
public:
	explicit Vector(int);
	Vector(const Vector&);
	Vector& operator=(const Vector&);
	~Vector();
	int& operator[](int);
	const int& operator[](int) const;
	int length() const;
	bool operator==(const Vector&) const;
	bool operator!=(const Vector&) const;
private:
	int size;
	int* data;
// niet in de les behandeld:
friend ostream& operator<<(ostream&, const Vector&);
};

Vector::Vector(int s): size(s), data(new int[s]) {
}

Vector::Vector(const Vector& v): size(v.size), data(new int[v.size]) {
	*this=v;
}

Vector& Vector::operator=(const Vector& r) {
	if (size!=r.size) {
		delete[] data;
		data=new int[r.size];
		size=r.size;
	}
	for (int i(0); i<size; ++i)
		data[i]=r.data[i];
	return *this;
}

Vector::~Vector() {
	delete[] data;
}

int& Vector::operator[](int index) {
	assert(index>=0 && index<size);
	return data[index];
}

const int& Vector::operator[](int index) const {
	assert(index>=0 && index<size);
	return data[index];
}

int Vector::length() const {
	return size;
}

bool Vector::operator==(const Vector& r) const {
	if (size!=r.size)
   	return false;
	for (int i(0); i<size; ++i)
		if (data[i]!=r.data[i])
			return false;
	return true;
}

bool Vector::operator!=(const Vector& r) const {
	return !(*this==r);
}

ostream& operator<<(ostream& o, const Vector& v) {
   for (int i(0); i<v.size; ++i) {
      o<<v.data[i];
      if (i!=v.size-1)
         o<<',';
   }
   return o;
}

int main() {
	cout<<"Hoeveel elementen moet de vector bevatten? ";
	int i; cin>>i;
   if (i>0) {
      Vector v(i);
      cout<<"v = "<<v<<endl;
      for (int j(0); j<v.length(); ++j)
         v[j]=j*j;	// vul v met kwadraten
      cout<<"v = "<<v<<endl;
      Vector w(v);
      cout<<"w = "<<w<<endl;
      cout<<"v[12] = "<<v[12]<<endl;
      cout<<"w[12] = "<<w[12]<<endl;
      v[0]=4; cout<<"v[0] = "<<v[0]<<endl;
      cout<<"v = "<<v<<endl;
      cout<<"w = "<<w<<endl;

      if (v==w) cout<<"v is nu gelijk aan w."<<endl;
      else cout<<"v is nu ongelijk aan w."<<endl;

      w=v;
      cout<<"w = v is uitgevoerd."<<endl;
      cout<<"v = "<<v<<endl;
      cout<<"w = "<<w<<endl;

      if (v!=w) cout<<"v is nu ongelijk aan w."<<endl;
      else cout<<"v is nu gelijk aan w."<<endl;
   }
   else
      cout<<"Doe niet zo negatief!"<<endl;
   cin.get();
   cin.get();
   return 0;
}
