#include "ListWindowEx.h"

DEFINE_RESPONSE_TABLE1(ListWindowEx, TListWindow)
   EV_WM_SIZE,
   EV_WM_PAINT,
   EV_WM_SETFOCUS,
   EV_WM_KILLFOCUS,
END_RESPONSE_TABLE;

ListWindowEx::ListWindowEx(TWindow* parent, int Id, int x, int y, int w, int h, TModule* module):
      TListWindow(parent, Id, x, y, w, h, module),
      m_cxClient(0) {
}

ListWindowEx::~ListWindowEx() {
}

void ListWindowEx::DrawItem(tagDRAWITEMSTRUCT& lpDrawItemStruct)
{
	TDC dc(lpDrawItemStruct.hDC);
	TRect rcItem(lpDrawItemStruct.rcItem);
	int nItem = lpDrawItemStruct.itemID;
	bool bFocus = (GetFocus() == GetHandle());
	COLORREF clrTextSave, clrBkSave;
	LPCTSTR pszText;

	TListWindItem lvi;
	lvi.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_STATE;
   lvi.stateMask = 0xFFFF;
	GetItem(lvi, nItem);

	bool bSelected(
   	(bFocus || GetStyle() & LVS_SHOWSELALWAYS) && lvi.state & LVIS_SELECTED ||
      lvi.state & LVIS_DROPHILITED
   );

	TRect rcAllLabels;
	GetItemRect(nItem, &rcAllLabels, Bounds);

	TRect rcLabel;
	GetItemRect(nItem, &rcLabel, Label);

	rcAllLabels.left = rcLabel.left;
	if (rcAllLabels.right<m_cxClient)
		rcAllLabels.right = m_cxClient;

	if (bSelected) {
		clrTextSave = dc.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
		clrBkSave = dc.SetBkColor(::GetSysColor(COLOR_HIGHLIGHT));
		dc.FillRect(rcAllLabels, TBrush(::GetSysColor(COLOR_HIGHLIGHT)));
	}
	else
		dc.FillRect(rcAllLabels, TBrush(GetTextBkColor()));

	GetItemRect(nItem, &rcItem, Label);

	pszText = MakeShortString(dc, lvi.pszText, rcItem.right-rcItem.left, 0);

	rcLabel = rcItem;

	dc.DrawText(pszText, -1, rcLabel, DT_LEFT|DT_SINGLELINE|DT_NOPREFIX|DT_NOCLIP|DT_VCENTER);

// draw labels for extra columns

	TListWindColumn lvc;
	lvc.mask = LVCF_FMT | LVCF_WIDTH;

	for(int nColumn = 1; GetColumn(nColumn, &lvc); nColumn++)
	{
		rcItem.left = rcItem.right;
		rcItem.right += lvc.cx;

   	TListWindItem lvsi;
		GetItem(lvsi, nItem, nColumn);
		pszText = MakeShortString(dc, lvsi.pszText, rcItem.right-rcItem.left, 0);

		rcLabel = rcItem;

		dc.DrawText(pszText, -1, rcLabel, DT_LEFT|DT_SINGLELINE|DT_NOPREFIX|DT_NOCLIP|DT_VCENTER);
	}

// draw focus rectangle if item has focus

	if (lvi.state & LVIS_FOCUSED && bFocus)
		dc.DrawFocusRect(rcAllLabels);

// set original colors if item was selected

	if (bSelected) {
		dc.SetTextColor(clrTextSave);
		dc.SetBkColor(clrBkSave);
	}
}

LPCTSTR ListWindowEx::MakeShortString(TDC& dc, LPCTSTR lpszLong, int nColumnLen, int nOffset) {
	static const _TCHAR szThreeDots[] = _T("...");

	int nStringLen = lstrlen(lpszLong);

	if (nStringLen == 0 ||
		(dc.GetTextExtent(lpszLong, nStringLen).cx + nOffset) <= nColumnLen) {
		return lpszLong;
	}

	static _TCHAR szShort[MAX_PATH];

	lstrcpy(szShort,lpszLong);
	int nAddLen = dc.GetTextExtent(szThreeDots,sizeof(szThreeDots)).cx;

	for (int i = nStringLen-1; i > 0; i--) {
		szShort[i] = 0;
		if ((dc.GetTextExtent(szShort, i).cx + nOffset + nAddLen) <= nColumnLen)
			break;
	}

	lstrcat(szShort, szThreeDots);
	return szShort;
}

void ListWindowEx::RepaintSelectedItems() {
	TRect rcItem, rcLabel;

// invalidate focused item so it can repaint properly

	int nItem = GetNextItem(-1, LVNI_FOCUSED);

	if (nItem != -1) {
		GetItemRect(nItem, &rcItem, Bounds);
		GetItemRect(nItem, &rcLabel, Label);
		rcItem.left = rcLabel.left;

		InvalidateRect(rcItem, false);
	}

// if selected items should not be preserved, invalidate them

	if(!(GetStyle() & LVS_SHOWSELALWAYS)) {
		for(nItem = GetNextItem(-1, LVNI_SELECTED);
			nItem != -1; nItem = GetNextItem(nItem, LVNI_SELECTED))
		{
			GetItemRect(nItem, &rcItem, Bounds);
			GetItemRect(nItem, &rcLabel, Label);
			rcItem.left = rcLabel.left;

			InvalidateRect(rcItem, FALSE);
		}
	}

// update changes

	UpdateWindow();
}

void ListWindowEx::EvSize(uint nType, TSize& size) {
	m_cxClient = size.X();
	TListWindow::EvSize(nType, size);
}

void ListWindowEx::EvPaint() {
	// in full row select mode, we need to extend the clipping region
	// so we can paint a selection all the way to the right
	if ((GetStyle() & LVS_TYPEMASK) == LVS_REPORT)
	{
		TRect rcAllLabels;
		GetItemRect(0, &rcAllLabels, Bounds);

		if(rcAllLabels.right < m_cxClient)
		{
			TPaintDC dc(GetHandle());

			TRect rcClip;
			dc.GetClipBox(rcClip);

			rcClip.left = min(rcAllLabels.right-1, rcClip.left);
			rcClip.right = m_cxClient;

			InvalidateRect(rcClip, false);
		}
	}

	TListWindow::EvPaint();
}

void ListWindowEx::EvSetFocus(THandle pOldWnd) {
	TListWindow::EvSetFocus(pOldWnd);

	// check if we are getting focus from label edit box
	if (pOldWnd!=NULL && pOldWnd == GetHandle())
		return;

	// repaint items that should change appearance
	if ((GetStyle() & LVS_TYPEMASK)==LVS_REPORT)
		RepaintSelectedItems();
}

void ListWindowEx::EvKillFocus(THandle pNewWnd) {
	TListWindow::EvKillFocus(pNewWnd);

	// check if we are losing focus to label edit box
	if (pNewWnd != NULL && pNewWnd == GetHandle())
		return;

	// repaint items that should change appearance
	if ((GetStyle() & LVS_TYPEMASK) == LVS_REPORT)
		RepaintSelectedItems();
}
